screenWidth, screenHeight = guiGetScreenSize( )

testPed = nil

itemsPacks = {
	{"Рубашка", 0, 0, 67 },
	{"Брюки", 2, 0, 44 },
	{"Обувь", 3, 0, 37 },
	{"Шляпа", 16, -1, 56 },
	{"Очки", 15, -1, 16 },

}

selectedClothes = {}
 
function showClothWindow()
	if not isElement ( clothWindow ) then
		showCursor (true)
		clothWindow = guiCreateWindow(0.07*screenWidth, 0.41*screenHeight, 268, 90+#itemsPacks*25, "ПЕРСОНАЖ", false)
		--clothWindow = guiCreateWindow(0.07, 0.41, 0.21, 0.35, "", true)
        guiWindowSetSizable(clothWindow, false)
		testPed = createPed ( 0, 1990, -765, 131, 270 )
		setCameraMatrix ( 1994, -765, 131, 1990, -765, 131 )
		addEventHandler('onClientRender', root, rotateTestPed )
		addEventHandler('onClientRender', root, renderRotateText )
		bindKey ( "mouse1", "down", setPrevX )
		x_prev = nil
		for i, v in ipairs ( itemsPacks ) do
			local rub_label = guiCreateLabel(11, 30+25*(i-1), 51, 20, v[1], false, clothWindow)
			local run_back_b = guiCreateButton(83, 30+25*(i-1), 30, 18, "<<", false, clothWindow)
			guiSetProperty(run_back_b, "NormalTextColour", "FFAAAAAA")
			local rub_back = guiCreateButton(124, 30+25*(i-1), 30, 18, "<", false, clothWindow)
			guiSetProperty(rub_back, "NormalTextColour", "FFAAAAAA")
			local rub_forw = guiCreateButton(188, 30+25*(i-1), 30, 18, ">", false, clothWindow)
			guiSetProperty(rub_forw, "NormalTextColour", "FFAAAAAA")
			local rub_forw_b = guiCreateButton(229, 30+25*(i-1), 30, 18, ">>", false, clothWindow)
			guiSetProperty(rub_forw_b, "NormalTextColour", "FFAAAAAA")
			local cur_cloth = getElementData ( localPlayer, "cloth"..v[2]) or v[3]
			local rub_num = guiCreateLabel(159, 30+25*(i-1), 22, 18, cur_cloth, false, clothWindow)
			guiLabelSetHorizontalAlign(rub_num, "center", false)    
			setElementData ( run_back_b, "clothButBackB", true )
			setElementData ( rub_forw_b, "clothButForwB", true )
			setElementData ( rub_back, "clothButBack", true )
			setElementData ( rub_forw, "clothButForw", true )
			setElementData ( run_back_b, "clothButID", i )
			setElementData ( rub_forw_b, "clothButID", i )
			setElementData ( rub_back, "clothButID", i )
			setElementData ( rub_forw, "clothButID", i )
			table.insert ( selectedClothes, { rub_num, cur_cloth, v[2], v[3], v[4] } )
			setPedClothes ( testPed, v[2], cur_cloth )
		end
		button_save = guiCreateButton(13, 30+#itemsPacks*25, 242, 23,"Сохранить",false,clothWindow)
		button_back = guiCreateButton(13, 55+#itemsPacks*25, 242, 23,"Закрыть",false,clothWindow)
		
		addEventHandler("onClientGUIClick", button_save, allowCloth )
		addEventHandler("onClientGUIClick", button_back, disallowCloth )
	end	
end

function renderRotateText()
	dxDrawText ( "Зажмите кнопку мыши и двигайте, чтобы повернуть пероснажа", 0, screenHeight/2+screenHeight/3,screenWidth,screenHeight, tocolor(255,255,255), 1.3, "sans","center")
end

function allowCloth ()
	if source ~= button_save then return true end
	for i, v in ipairs ( itemsPacks ) do
		setElementData ( localPlayer, "cloth"..v[2], selectedClothes[i][2] )
	end
	outputChatBox ( "Одежда сохранена!", 30, 250, 30 )
	--closeClothWindow()
end

function disallowCloth ()
	if source ~= button_back then return true end
	closeClothWindow()
end

function closeClothWindow ()
	destroyElement ( clothWindow )
	destroyElement ( testPed )
	selectedClothes = {}
	unbindKey ( "mouse1", "down", setPrevX )
	removeEventHandler('onClientRender', root, rotateTestPed )
	removeEventHandler('onClientRender', root, renderRotateText )
	setCameraMatrix(6237, -2027, 40, 6269, -2029, 27)
	exports.login:startInfoWindow()
	showCursor ( false )
end

x_prev = nil
 
function setPrevX()
	x, _ = getCursorPosition ()
	x_prev = x*screenWidth
end

function rotateTestPed()
	if getKeyState ("mouse1") then
		x, _ = getCursorPosition ()
		x=x*screenWidth
		change_rot = (x-x_prev)
		local _, _, ped_rot = getElementRotation ( testPed )
		local rot_to = ped_rot+change_rot
		if rot_to < 0 then
			rot_to = ped_rot+change_rot+360
		end
		setElementRotation ( testPed, 0, 0, rot_to )
		x_prev = x
	end
end

function clickOntoCloth ()
	local id = getElementData ( source, "clothButID" ) or 0 
	if id > 0 then
		local setCloth = selectedClothes[id][4]
		if getElementData ( source, "clothButBackB" ) then
			setCloth = selectedClothes[id][4]
		elseif getElementData ( source, "clothButForwB" ) then
			setCloth = selectedClothes[id][5]
		elseif getElementData ( source, "clothButBack" ) then
			if selectedClothes[id][2] > selectedClothes[id][4] then
				setCloth = selectedClothes[id][2]-1
			else
				setCloth = selectedClothes[id][5]
			end
		elseif getElementData ( source, "clothButForw" ) then
			if selectedClothes[id][2] < selectedClothes[id][5] then
				setCloth = selectedClothes[id][2]+1
			end
		end
		selectedClothes[id][2] = setCloth
		guiSetText (selectedClothes[id][1],setCloth)
		setPedClothes ( testPed, selectedClothes[id][3], setCloth )
	end
end

addEventHandler("onClientGUIClick", root, clickOntoCloth )

function setPedClothes(thePed, clothingSlot, clothingID)
	if not isElement(thePed) or type(clothingSlot) ~= "number" then
		error("Invalid arguments to setPedClothes()!", 2)
	end
 
	if not clothingID or clothingID == -1 then
		return removePedClothes(thePed, clothingSlot)
	end
 
	local hasClothes = getPedClothes(thePed, clothingSlot) 
	if hasClothes then
		removePedClothes(thePed, clothingSlot)
	end
	
	local texture, model = getClothesByTypeIndex(clothingSlot, clothingID)
	return addPedClothes(thePed, texture, model, clothingSlot)
end

addEventHandler( "onClientElementStreamIn", getRootElement( ),
    function ( )
        if getElementType( source ) == "player" or ( getElementType( source ) == "ped" and getElementData ( source, "deadman" ) ) and getElementModel ( source ) == 0 then
            for i, v in ipairs ( itemsPacks ) do
				setPedClothes (source,v[2],getElementData ( source, "cloth"..v[2] ) or 0)
			end
        end
    end
);

function updatePlayerClothesC (skin)
	if isElement ( source ) then 
		if skin == 0 then
			for i, v in ipairs ( itemsPacks ) do
				setPedClothes (source,v[2],getElementData ( source, "cloth"..v[2] ) or 0)
			end
		else
			for i, v in ipairs ( itemsPacks ) do
				removePedClothes(source, v[2])
			end
		end
	end
end

addEvent("updatePlayerClothes", true)
addEventHandler("updatePlayerClothes", getRootElement(), updatePlayerClothesC)

function putPlayerClothesOnSpawn ()
	if getElementModel ( localPlayer ) == 0 then
		for i, v in ipairs ( itemsPacks ) do
			setPedClothes (localPlayer,v[2],getElementData ( localPlayer, "cloth"..v[2] ) or 0)
		end
	end
end

addEvent("onClientPlayerDayZSpawn", true)
addEventHandler("onClientPlayerDayZSpawn", getRootElement(), putPlayerClothesOnSpawn)

addEvent("onClientPlayerDayZLogin", true)
addEventHandler("onClientPlayerDayZLogin", getRootElement(), putPlayerClothesOnSpawn)